/**
* \file: am_api_socket_client.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AM_API_SOCKET_CLIENT_H
#define AM_API_SOCKET_CLIENT_H

#include "automounter_types.h"
#include "ipc/message_buffer.h"

error_code_t am_api_socket_client_init(void);

void am_api_socket_client_deinit(void);

error_code_t am_api_socket_client_connect(void);

void am_api_socket_client_disconnect(void);

error_code_t am_api_socket_client_send_message(message_buffer_t *msg_buffer);

error_code_t am_api_socket_client_check_daemon_running(void);

error_code_t am_api_socket_client_start_waiting_for_socket(void);

void am_api_socket_client_stop_waiting_for_socket(void);

#endif
